/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.planning.ActivityChange;
import cz.insophy.inplan.planning.mokos.MinimalTimeBound;
import cz.insophy.inplan.planning.mokos.MinimalTimeBoundLowLevel;
import cz.insophy.inplan.planning.mokos.OperationGroup;
import cz.insophy.inplan.planning.mokos.Util;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Operation {
    private static final Logger log = LoggerFactory.getLogger(Operation.class);
    private final GeneralizedActionRequest gar;
    private final Action action;
    public final int id;
    private MinimalTimeBound bound;
    private Map<String, PropertyWrapper> globalProperties;
    private Set<Operation> predecessors;
    private Set<Operation> predecessorsView;
    private Set<Operation> successors;
    private Set<Operation> successorsView;
    private List<OperationPlanning> possiblePlannings;
    private List<OperationPlanning> possiblePlanningsView;
    private boolean isPlanned;
    private boolean isActiongramStart;
    private OperationGroup group;
    private OperationGroup laGroup;

    public Operation(GeneralizedActionRequest gar, Action action, int id) {
        this.gar = gar;
        this.action = action;
        this.id = id;
        this.group = null;
        this.bound = new MinimalTimeBoundLowLevel();
        this.globalProperties = Maps.newHashMap();
        this.predecessors = Sets.newHashSet();
        this.predecessorsView = Collections.unmodifiableSet(this.predecessors);
        this.successors = Sets.newHashSet();
        this.successorsView = Collections.unmodifiableSet(this.successors);
        this.possiblePlannings = Lists.newArrayList();
        this.possiblePlanningsView = Collections.unmodifiableList(this.possiblePlannings);
        this.isPlanned = false;
    }

    public void setGroup(OperationGroup group) {
        this.group = group;
    }

    public void setLaGroup(OperationGroup group) {
        this.laGroup = group;
    }

    public OperationGroup getLaGroup() {
        return this.laGroup;
    }

    public boolean hasLag() {
        return this.laGroup != null && this.laGroup.size() > 1;
    }

    public MinimalTimeBound.BoundDefinition getBound() {
        return this.bound.getBound();
    }

    public MinimalTimeBound getBounds() {
        return this.bound;
    }

    public void updateCompositeBound(Object owner, Object specifier, long time) {
        this.hookBoundUpdate(owner, specifier, time);
        this.bound.updateCompositeBound(owner, specifier, time);
    }

    public void updateSimpleBound(Object owner, long time) {
        this.hookBoundUpdate(owner, "", time);
        this.bound.updateSimpleBound(owner, time);
    }

    private void hookBoundUpdate(Object owner, Object specifier, long time) {
    }

    public GeneralizedActionRequest getGar() {
        return this.gar;
    }

    public Action getAction() {
        return this.action;
    }

    public void setProperty(String key, Object value) {
        PropertyWrapper pw = this.globalProperties.get(key);
        if (pw == null) {
            pw = new PropertyWrapper();
            this.globalProperties.put(key, pw);
        }
        pw.value = value;
    }

    @Nullable
    public Object getProperty(String key) {
        PropertyWrapper pw = this.globalProperties.get(key);
        return pw != null ? pw.value : null;
    }

    public void addPredecessor(Operation op) {
        if (!this.predecessors.add(op)) {
            throw new IllegalStateException("Predecessor " + op + " is already present.");
        }
    }

    public void removePredecessor(Operation op) {
        if (!this.predecessors.remove(op)) {
            throw new IllegalStateException("Predecessor " + op + " was not present.");
        }
    }

    public Set<Operation> getPredecessors() {
        return this.predecessorsView;
    }

    public void addSuccessor(Operation op) {
        if (!this.successors.add(op)) {
            throw new IllegalStateException("Successor " + op + " is already present.");
        }
    }

    public void removeSuccessor(Operation op) {
        if (!this.successors.remove(op)) {
            throw new IllegalStateException("Successor " + op + " was not present.");
        }
    }

    public Set<Operation> getSuccessors() {
        return this.successorsView;
    }

    public void addPlanning(List<ActivityChange> actChanges) {
        OperationPlanning planning = new OperationPlanning(actChanges);
        this.addPlanning(planning);
    }

    protected void addPlanning(OperationPlanning planning) {
        if (this.isPlanned) {
            throw new IllegalStateException("Possible plannings of a planned operation cannot be changed.");
        }
        this.possiblePlannings.add(planning);
    }

    public List<OperationPlanning> getPlannings() {
        return this.possiblePlanningsView;
    }

    public void setPlanned(boolean isPlanned) {
        this.isPlanned = isPlanned;
    }

    public boolean isPlanned() {
        return this.isPlanned;
    }

    public void retainPlanning(OperationPlanning planning) {
        Preconditions.checkArgument(this.possiblePlannings.contains(planning));
        this.possiblePlannings.clear();
        this.possiblePlannings.add(planning);
    }

    public void clearPlannings() {
        this.possiblePlannings.clear();
        this.isPlanned = false;
    }

    public void setActiongramStart(boolean isActiongramStart) {
        this.isActiongramStart = isActiongramStart;
    }

    public boolean isActiongramStart() {
        return this.isActiongramStart;
    }

    public boolean isGrouped() {
        return this.group != null;
    }

    public OperationGroup getGroup() {
        return this.group;
    }

    public String toString() {
        if (this.gar != null) {
            String gorId = ProductionTreeAlgorithms.getNearestGor(this.gar).getId();
            if (this.action.hasLocalAlts()) {
                return gorId + "/" + this.action.getName() + "/" + this.action.getLocalAltName() + "(" + this.gar.getAmount() + ")";
            }
            return gorId + "/" + this.action.getName() + "(" + this.gar.getAmount() + ")";
        }
        return super.toString();
    }

    public Collection<Operation> getLaOps() {
        return this.laGroup != null ? this.laGroup.getOperations() : Collections.singleton(this);
    }

    public Collection<Operation> getOtherLaOps() {
        return this.laGroup != null ? Collections2.filter(this.laGroup.getOperations(), Predicates.not(Predicates.equalTo(this))) : Collections.emptyList();
    }

    private static class PropertyWrapper {
        public Object value;

        private PropertyWrapper() {
        }
    }

    public class OperationPlanning {
        private List<ActivityChange> activityChanges;
        private List<ActivityChange> activityChangesView;
        private Map<String, PropertyWrapper> planningProperties;

        public OperationPlanning(List<ActivityChange> activityChanges) {
            this.activityChanges = activityChanges;
            this.activityChangesView = Collections.unmodifiableList(this.activityChanges);
            this.planningProperties = Maps.newHashMap();
        }

        public List<ActivityChange> getActivityChanges() {
            return this.activityChangesView;
        }

        public void setProperty(String key, Object value) {
            PropertyWrapper pw = this.planningProperties.computeIfAbsent(key, k -> new PropertyWrapper());
            pw.value = value;
        }

        @Nullable
        public Object getProperty(String key) {
            PropertyWrapper pw = this.planningProperties.get(key);
            if (pw == null) {
                pw = Operation.this.globalProperties.get(key);
            }
            return pw == null ? null : pw.value;
        }

        public Collection<WorkplaceSpan> getWorkplaceAaSpans() {
            return this.getWorkplaceSpans(ActionActivity.class);
        }

        private <T extends WorkplaceActivity> Collection<WorkplaceSpan> getWorkplaceSpans(Class<T> cls) {
            IdentityHashMap<Workplace, WorkplaceSpan> spans = Maps.newIdentityHashMap();
            for (ActivityChange ac : this.activityChanges) {
                if (ac.getChangeType() != ActivityChange.ChangeType.ADDED || !cls.isInstance(ac.getActivity())) continue;
                Workplace wp = ((WorkplaceActivity)ac.getActivity()).getWorkplace();
                WorkplaceSpan wpSpan = spans.computeIfAbsent(wp, WorkplaceSpan::new);
                wpSpan.update((WorkplaceActivity)ac.getActivity());
            }
            return spans.values();
        }

        public String toString() {
            return "Planning(" + Util.getFirstPlannedWa(this) + ", ..., " + Util.getLastPlannedWa(this) + ")";
        }
    }

    public static class WorkplaceSpan {
        private final Workplace workplace;
        private long start;
        private long end;

        private WorkplaceSpan(Workplace wp) {
            this.workplace = wp;
            this.start = Long.MAX_VALUE;
            this.end = Long.MIN_VALUE;
        }

        private void update(WorkplaceActivity wa) {
            if (wa.getStart() < this.start) {
                this.start = wa.getStart();
            }
            if (wa.getEnd() > this.end) {
                this.end = wa.getEnd();
            }
        }

        public Workplace getWorkplace() {
            return this.workplace;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }
    }
}

